package com.ElyStudio.leGaou.utilities;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;

import java.util.Locale;

public class LanguageManager {

    private final Context context;
    private final SharedPreferences sharedPreferences;

    public  LanguageManager (Context ctx){
        context = ctx;
        sharedPreferences = context.getSharedPreferences(Constants.appPrefs,Context.MODE_PRIVATE);
    }

    public void updateLanguage(String langCode){
        Locale locale = new Locale(langCode);
        Locale.setDefault(locale);
        Resources resources = context.getResources();
        Configuration configuration = resources.getConfiguration();
        configuration.locale = locale;
        configuration.setLayoutDirection(locale);
        resources.updateConfiguration(configuration,resources.getDisplayMetrics());
        setLanguage(langCode);
    }

    public String getLangCode(){
        return  sharedPreferences.getString(Constants.appLanguage,Constants.DEFAULT_APP_LANGUAGE);
    }

    private void setLanguage(String langCode){
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(Constants.appLanguage,langCode);
        editor.apply();
    }
}
